%% File agjahresberich.cls
%%
%% Buch: Verkleinerung 0.918

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{agjahresbericht}[2025/02/28 (KR)]

\LoadClass[twoside]{article}

\usepackage{german}
\usepackage[utf8]{inputenc}
\usepackage[T1]{fontenc}
\usepackage{a4}
\usepackage{graphicx}
\usepackage{tabularx}
\usepackage{eurosym}

\def\berichtsjahr{2025}
\def\band{109}
\def\erscheinungsjahr{2026}

\def\praefix{}
\def\suffix{}

% Satzparameter
\parindent=0pt
\parskip=1ex plus 0.8ex minus 0.2ex
\textwidth=137.6mm
\textheight=207mm
\oddsidemargin=0in
\evensidemargin=0mm
\topmargin=-0.5in
\headheight=7pt
\headsep=8mm
\topskip=12pt

% neuer Bericht muss auf rechter Seite anfangen
\def\rechteSeite{\ifodd\count0 \else \neueSeite \fi}
\def\neueSeite{\thispagestyle{empty}\leavevmode\newpage}

\newfont{\fett}{cmbx12 scaled 1200}

\def\baselinestretch{0.8748}
\frenchspacing

\pagestyle{myheadings}
\markboth{}{}

\newcounter{EndPage}

\setcounter {page}{1}
\setcounter{EndPage}{99} \rechteSeite

% Erste Berichtsseite
\def\AnfangVorspann{
\setcounter{UA}{-1}
\vspace*{-1.72cm}
\thispagestyle{empty}
{\footnotesize{Jahresbericht \berichtsjahr \hfill
Mitteilungen der {\sc Astronomischen Gesellschaft} {\bf \band} (\erscheinungsjahr),
\thepage --\theEndPage
}}\vspace*{1.4cm}
}

% K O P F Z E I L E
\def\Kopfzeile#1{\markboth{\protect\it #1}{\protect\it #1}}
% pagestyle "ohnetitel" macht Seite ohne Kopfzeile
\makeatletter
\def\ps@ohnetitel{\let\@mkboth\@gobbletwo
 \def\@oddhead{\hfil \rm\thepage}%
 \def\@oddfoot{}\def\@evenhead{\rm \thepage\hfil}%
 \def\@evenfoot{}\def\sectionmark##1{}\def\subsectionmark##1{}}
\makeatother

%Inhaltsverzeichnis
\newdimen\inhaltsverzeichnistextlaenge\inhaltsverzeichnistextlaenge=\textwidth
\advance\inhaltsverzeichnistextlaenge by -15mm
\def\inhaltsverzeichnis{\begingroup
\makeatletter\csname @input\endcsname{aghaupt.inh}
\expandafter\newwrite\csname tf@inh\endcsname
\immediate\openout \csname tf@inh\endcsname aghaupt.inh\relax
\makeatother\endgroup
}

%%\def\inhaltsverzeichnis{\leavevmode\makeatletter\@starttoc{inh}\makeatother}
\def\EintraginsInhaltsverzeichnisA#1{
     \advance\count0 by 1
     \addcontentsline{inh}{A}{#1}
     \advance\count0 by -1 }
\def\EintraginsInhaltsverzeichnisB#1{
     \advance\count0 by 1
     \addcontentsline{inh}{B}{#1}
     \advance\count0 by -1 }

\makeatletter
\def\l@A#1#2{\begingroup\rightskip=10mm\parfillskip=-10mm{\leavevmode#1\dotfill{#2}\par}\endgroup}
\def\l@B#1#2{\quad #1\dotfill#2\par}
\makeatother

\def\neuezeile{\par}

% U E B E R S C H R I F T E N
% Platz vor und nach Ueberschriften
\newskip\voraskip\newskip\nachaskip\newskip\vorbskip
\newskip\nachbskip\newskip\vorcskip\newskip\nachcskip
\voraskip=2.5ex plus 1ex minus 1ex
\nachaskip=1ex plus 1ex minus 0.2ex
\vorbskip=1ex plus 0.5ex minus 0.5ex
\nachbskip=0.01ex
\vorcskip=0.5ex plus 0.2ex minus 0.2ex
\nachcskip=0.01ex

\newcounter{UA}\newcounter{UB}[UA]\newcounter{UC}[UB]
\def\theUA{\arabic{UA}}\def\theUB{\theUA.\arabic{UB}}
\def\UAmark#1{}\def\UBmark#1{}\def\UCmark{}
% Aussehen der Ueberschriften verschiedener Hierarche
\makeatletter
\def\UA{\@startsection{UA}{1}{0pt}{\voraskip}{\nachaskip}{\large\bf}}
\def\UB{\@startsection{UB}{2}{0pt}{\vorbskip}{\nachbskip}{\large}}
\def\UC{\@startsection{UC}{3}{0pt}{\vorcskip}{\nachcskip}{\it}*}
\makeatother

% Diverses
%\def\th{\thinspace}
\def\th{\kern.08em}

% Spezielles
\def\Ort{\vspace*{2cm}\begin{center}\LARGE\bf}
\def\Institut{\rm \vrule height 4ex width 0pt\Large}
\def\Adresse{\vrule height 4ex width 0pt\normalsize}
\def\EndeVorspann{\end{center}}

\def\Allgemeines{\UA{Allgemeines}}

\def\Personal{\UA{Personal und Ausstattung}}
  \def\Personalstand{\UB{Personalstand}}
    \def\DirektorenProfessoren#1{\UC{Direktoren und Professoren: \ifx#1\empty \else #1\fi}}
    \def\Direktoren#1{\UC{Direktoren: \ifx#1\empty \else #1\fi}}
    \def\Professoren#1{\UC{Professoren: \ifx#1\empty \else #1\fi}}
    \def\WissenschaftlicheMitarbeiter#1{\UC{Wissenschaftliche Mitarbeiter: \ifx#1\empty \else #1\fi}}
    \def\WissenschaftlicheMitarbeitende#1{\UC{Wissenschaftliche Mitarbeitende: \ifx#1\empty \else #1\fi}}
    \def\Praktikanten#1{\UC{Praktikanten: \ifx#1\empty \else #1\fi}}  
    \def\BachelorMasterstudenten#1{\UC{Bachelor- und Masterstudenten: \ifx#1\empty \else #1\fi}}
    \def\Bachelorstudenten#1{\UC{Bachelorstudenten: \ifx#1\empty \else #1\fi}}
    \def\Masterstudenten#1{\UC{Masterstudenten: \ifx#1\empty \else #1\fi}}
    \def\Diplomanden#1{\UC{Diplomanden: \ifx#1\empty \else #1\fi}}
    \def\Doktoranden#1{\UC{Doktoranden: \ifx#1\empty \else #1\fi}}
    \def\Staatsexamen#1{\UC{Staatsexamen: \ifx#1\empty \else #1\fi}}
    \def\Sekretariat#1{\UC{Sekretariat und Verwaltung: \ifx#1\empty \else #1\fi}}
    \def\TechnischeMitarbeiter#1{\UC{Technische Mitarbeiter: \ifx#1\empty \else #1\fi}}
    \def\StudentischeMitarbeiter#1{\UC{Studentische Mitarbeiter: \ifx#1\empty \else #1\fi}}
    \def\Gaeste#1{\UC{G\"aste: \ifx#1\empty \else #1\fi}}
  \def\InstrumenteRechenanlagen{\UB{Instrumente und Rechenanlagen}}
  \def\GebaeudeBibliothek{\UB{Geb\"aude und Bibliothek}}

\def\WissenschaftlicheArbeiten{\UA{Wissenschaftliche Arbeiten}}

\def\AkademischeAbschlussarbeiten{\UA{Akademische Abschlussarbeiten}}
  \def\Bachelorarbeiten{\UB{Bachelorarbeiten}}
    \def\AbgeschlosseneBachelorarbeiten#1{\UC{Abgeschlossen: \ifx#1\empty \else #1\fi}}
    \def\LaufendeBachelorarbeiten{\UC{Laufend:}}
  \def\Masterarbeiten{\UB{Masterarbeiten}}
    \def\AbgeschlosseneMasterarbeiten#1{\UC{Abgeschlossen: \ifx#1\empty \else #1\fi}}
    \def\LaufendeMasterarbeiten{\UC{Laufend:}}
  \def\Dissertationen{\UB{Dissertationen}}
    \def\AbgeschlosseneDissertationen#1{\UC{Abgeschlossen: \ifx#1\empty \else #1\fi}}
    \def\LaufendeDissertationen{\UC{Laufend:}}
  \def\Habilitationen{\UB{Habilitationen}}
    \def\AbgeschlosseneHabilitationen#1{\UC{Abgeschlossen: \ifx#1\empty \else #1\fi}}
    \def\LaufendeHabilitationen{\UC{Laufend:}}

\def\Veroeffentlichungen{\UA{Ver\"offentlichungen}}
  \def\Zeitschriften#1{\UB{In referierten Zeitschriften \ifx#1\empty \else (#1)\fi}
               \everypar={\hangindent=2em} \parskip=1ex}
  \def\Konferenzbeitraege#1{\UB{Konferenzbeitr\"age \ifx#1\empty \else (#1)\fi}
                \everypar={\hangindent=2em} \parskip=1ex}
  \def\SonstigeVeroeffentlichungen#1{\UB{Popul\"arwissenschaftliche
       und sonstige Ver\"offentlichungen \ifx#1\empty \else (#1)\fi}
		\everypar={\hangindent=2em} \parskip=1ex} % plus 0.4ex minus 0.2ex}
\def\EndeVeroeffentlichungen{\everypar={}\parskip=1ex\leavevmode}

\def\LehrePruefungenGremien{\UA{Lehrt\"atigkeit, Pr\"ufungen und
     Gremient\"atigkeit}}
  \def\Lehrtaetigkeit{\UB{Lehrt\"atigkeiten}}
  \def\SchuelerPraktikanten{\UB{}}
  \def\Pruefungen{\UB{Pr\"ufungen}}
  \def\Gremien{\UB{Gremient\"atigkeit}}

\def\TagungenProjekteBeobachtungen{\UA{Tagungen, Projekte am
     Institut und Beobachtungszeiten}}
  \def\TagungenVeranstaltungen{\UB{Tagungen und Veranstaltungen}}
  \def\Projekte{\UB{Projekte und Kooperationen mit anderen Instituten}}
  \def\Beobachtungszeiten{\UB{Beobachtungszeiten}}

\def\AuswaertigeTaetigkeiten{\UA{Ausw\"artige T\"atigkeiten}}
  \def\Tagungen{\UB{Nationale und internationale Tagungen}}
  \def\VortraegeGastaufenthalte{\UB{Vortr\"age und Gastaufenthalte}}
  \def\BeobachtungenMesskampagnen{\UB{Beobachtungsaufenthalte,
       Me"skampagnen}}
  \def\Kooperationen{\UB{Kooperationen}}
  \def\Reisen{\UB{Sonstige Reisen}}

\def\WeitereAktivitaeten{\UA{Weitere Aktivit\"aten}}

\def\Abkuerzungsverzeichnis{\UA{Abk\"urzungsverzeichnis}}

\def\Signatur{\hfill}

%% Ende der Datei `agjahresbericht.cls'.
